import com.xebialabs.restito.semantics.Call;
import com.xebialabs.restito.semantics.Predicate;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.server.StubServer;

import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.server.Response;

import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Condition.custom;
import static com.xebialabs.restito.semantics.Condition.method;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.io.IOException;

public class ClinicProfileMock extends AbstractMock {
    private static String template;

    public ClinicProfileMock() {

        template = loadTemplate("clinic-profile.json");
    }

    @Override
    public void run(StubServer server) {
        Predicate<Call> validUri = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {

                return input.getUri().matches(".*/clinic-service/patient/EDIPI/.*/site/.*/clinic-profile/.*");
            }
        };

        Function<Response, Response> response = new Function<Response, Response>() {
            @Override
            public Response apply(Response input) {
                String uri = input.getRequest().getRequestURI();
                String patientIdRegex = ".*/patient/EDIPI/(.*)/site";
                String patientId = matchingRegex(uri, patientIdRegex);

                String siteCodeRegex = ".*/site/(\\d+)/clinic-profile";
                String siteCode = matchingRegex(uri, siteCodeRegex);

                String clinicIdRegex = ".*/clinic-profile/(\\d+)";
                String clinicId = matchingRegex(uri, clinicIdRegex);
                String output = "";

                if(patientId.equals("P011")) {
                    if (siteCode.equals("523")) {
                        output = createClinicProfile(siteCode, clinicId, "GENERIC CLINIC NAME", 10);
                    } else if (siteCode.equals("650") && clinicId.equals("3002")) {
                        output = createClinicProfile(siteCode, clinicId, "GENERIC CLINIC NAME", 20);
                    } else {
                        output = createClinicProfile(siteCode, clinicId, "GENERIC CLINIC NAME", 30);
                    }
                } else {
                    output = createClinicProfile(siteCode, clinicId, "GENERIC CLINIC NAME", 30);
                }

                try {
                    input.getWriter().write(output);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return input;
            }
        };

        whenHttp(server).match(custom(validUri), method(Method.GET))
            .then(generateResponse(HttpStatus.OK_200, response));
    }

    private String createClinicProfile(String siteCode, String clinicId, String clinicName, int appointmentLength) {
        StringBuffer result = new StringBuffer();

        DateTime today = new DateTime();
        DateTimeFormatter formatter = DateTimeFormat.forPattern("MM/dd/yyyy HH:mm:ss");

        result.append(String.format(template, siteCode, clinicId, clinicName, appointmentLength, formatter.print(today)));

        return result.toString();
    }
}
